//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Threading;

namespace ThreadExceptions
{
	public delegate int WorkerDelegate();

	public class ExceptionHandlers 
	{
		static void ExceptionFilter(object o, UnhandledExceptionEventArgs e) 
		{
			Console.WriteLine("Wewntrz ExceptionFilter w wtku: {0} IsTerminating: {1}",
				AppDomain.GetCurrentThreadId(), e.IsTerminating);
		}
		static void ThreadStartCallback() 
		{
			Console.WriteLine("Wewntrz ThreadStartCallback w wtku {0}", AppDomain.GetCurrentThreadId());
			int result = WorkerThatThrowsException();
			Console.WriteLine("Wewntrz ThreadStartCallback odpowied brzmi {0}", result);
		}
		static int WorkerThatThrowsException() 
		{
			Console.WriteLine("Wewntrz WorkerThatThrowsException w wtku {0}", AppDomain.GetCurrentThreadId());
			throw new ArgumentException();
			Console.WriteLine("WorkerThatThrowsException zgasza odpowied");
			return 0;
		}
		static void Main() 
		{
			Console.WriteLine("Wewntrz Main w wtku {0}",
				AppDomain.GetCurrentThreadId());
			AppDomain.CurrentDomain.UnhandledException += new
				UnhandledExceptionEventHandler(ExceptionFilter);

			WorkerDelegate wd = new WorkerDelegate(WorkerThatThrowsException);
			ThreadStart ts = new ThreadStart(ThreadStartCallback);
			Thread t = new Thread(ts);
			t.Start();
			Console.ReadLine();
			Console.WriteLine();
			try 
			{
				int result = wd();
				Console.WriteLine("Wewntrz Main odpowied brzmiaa {0}", result);
			} 
			catch (Exception e) 
			{
				Console.WriteLine("Przechwyconow wyjtek w Main:");
				Console.WriteLine(e.ToString());
			}
		}
	}
}
